<?php  

	require('includes/conexao.php');
	require('includes/funcoes.php');
	require('includes/cabecalho.php');

?>
	
<div id="main" class="tbmain" style="height:auto"> 
	<script type="text/javascript">
		$(document).ready(function() {
			$('#inscrevame').attr('disabled', true).attr('readonly', 'readonly');
			$('input').attr('disabled', true).attr('readonly', 'readonly');
		});

		function formatarTelefone(input) {
			let valor = input.value.replace(/\D/g, ''); // Remove caracteres não numéricos

			if (valor.length <= 4) {
				input.value = `${valor}`;
			} else if (valor.length <= 6) {
				input.value = `${valor.slice(0, 2)} ${valor.slice(2)}`;
			} else if (valor.length <= 10) {
				input.value = `${valor.slice(0, 2)} ${valor.slice(2, 4)} ${valor.slice(4)}`;
			} else if (valor.length === 11) {
				input.value = `${valor.slice(0, 2)} ${valor.slice(2, 4)} ${valor.slice(4, 7)}-${valor.slice(7)}`;
			} else {
				input.value = `${valor.slice(0, 2)} ${valor.slice(2, 4)} ${valor.slice(4, 9)}-${valor.slice(9)}`;
			}
		}
	</script>
	<div class="pagebreak" align="center" style="padding:2%;">  

		<div><h2>Nova Inscrição<br /><span class="required">(*) Para quem nunca se inscreveu para fazer algum curso EAD-ESE da Comunhão</span></h2></div>

		<form id="frmNovaInscricao" name="frmNovaInscricao" action="" method="post">

			<table width="750px" cellpadding="5" cellspacing="3" border="0">
				<tr class="trEscura">

					<td width="180px" class="right">

						<label>Curso em que deseja se inscrever:</label>

					</td>

					<td class="left">

					<?php  

						//Select na tabela de tbl_curso
						$sql = "SELECT
									idCurso,
									nomeCurso,
									status
								FROM tbl_curso
								WHERE (status = 1)
								ORDER BY nomeCurso ASC";

						$resultado = mysqli_query($conn, $sql);

						//Total de linha retornadas.
						$qtdLinhas = mysqli_num_rows($resultado);

						//Contador
						$cont = 0;

						if ($qtdLinhas > 0 ) {

							while($rs=mysqli_fetch_array($resultado, MYSQLI_ASSOC)){

								$id = $rs["idCurso"];
								$nomeCurso = $rs["nomeCurso"];
					?>

								<input type="radio" name="Curso" class="other" id="curso_<?php echo $cont; ?>" value="<?php echo $id; ?>" />
								<label class="left"><?php echo $nomeCurso; ?></label> <br /> 

					<?php 
								$cont++;

							} 	
						}						
					?>	

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Nome completo: <span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="60" name="Nome" id="Nome" class="text" value="" maxlength="100" maxsize="150" tabindex="1" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>Data de Nascimento:</label>

					</td>

					<td class="left">

						<input type="text" size="10" name="DatadeNacimento" id="DatadeNacimento" class="text" maxlength="10" onKeyPress="return fncFormatCampos('DatadeNacimento', '99/99/9999', event);"/>

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Telefone Residencial: <span class="required">*</span></label>

					</td>

					<td class="left"><!-- 55 61 3403.0000 return fncFormatCampos('TelResidencial', '00 00 00000000', event);-->

						<input type="text" size="15" name="TelResidencial" id="TelResidencial" class="text" maxlength="16" onKeyPress="$(this).mask('(00) 0000-0000')" />

						<span class="requiredMark">Ex.: 00 00 00000000</span>

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>Telefone Trabalho: </label>

					</td>

					<td class="left">
					<!-- return fncFormatCampos('TelTrabalho', '00 00 00000000', event); -->
						<input type="text" size="15" name="TelTrabalho" id="TelTrabalho" class="text" maxlength="20" onKeyPress="formatarTelefone(this)" />

						<span class="requiredMark">Ex.: 00 00 00000000</span>

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Telefone Celular: <span class="required">*</span></label>

					</td>

					<td class="left">
						<!-- return fncFormatCampos('TelCelular', '00 00 00000000', event); aplicarMascara(this, 'TelCelular')-->
						<input type="text" size="15" name="TelCelular" id="TelCelular" class="text" maxlength="15" onKeyPress="aplicarMascara(this, 'TelCelular');" />

						<span class="requiredMark">Ex.: 00 00 00000000</span>

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>E-mail: <span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="60" name="Email" id="Email" class="text" value="" maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Confirmar E-mail: <span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="60" name="ConfirmarEmail" id="ConfirmarEmail" class="text" value="" maxlength="100" maxsize="100" onkeyup="return fncBloqueiCopiaCola(event);" onkeydown="return fncBloqueiCopiaCola(event);" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>Para a matrícula, precisamos que responda é pergunta: Sua nacionalidade é brasileira?<span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="radio" name="Nacionalidade" class="other" id="nacionalidade_1" value="1" onclick="fncHabilita(1, null, null);" /> Sim <br />

						<input type="radio" name="Nacionalidade" class="other" id="nacionalidade_2" value="2" onclick="fncHabilita(2, null, null);" /> Não

					</td>

				</tr>

				<tr class="trEscura" style="display: none" id="campoIdentificador">

				</tr>

				<tr>

					<td width="170px" class="right" valign="top">
						<label>CEP:<span class="required">*</span></label>
					</td>
					<!-- "return fncFormatCampos('cep', '00000-000', event);" -->
					<td class="left">
						<input type="text" size="15" name="cep" value="" class="text" id="cep" maxlength="9" maxsize="9" onKeyPress="$(this).mask('00000-000')" />
						<span class="requiredMark">Ex.: 00000-000</span>
						<input type="button" class="btn" value="Pesquisar CEP" title="Pesquisar CEP" onclick="buscarCep(this.value);" /> <!-- -->
					</td>

				</tr>
				<tr>

					<td width="170px" class="right" valign="top">

						<label>País: <span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="30" name="Pais" class="text" value="" id="Pais" maxlength="50" maxsize="60" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>Endereço:<span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="60" name="Endereco" id="Endereco" class="text" value=""  maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Complemento:</label>

					</td>

					<td class="left">

						<input type="text" size="50" name="Complemento" id="Complemento" class="text" value=""   maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right" valign="top">

						<label>Cidade:<span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="30" name="Cidade" class="text" value="" id="Cidade" maxlength="50" maxsize="60" />

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Bairro:<span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="50" name="Bairro" class="text" value="" id="Bairro"  maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right" valign="top">

						<label>UF: <span class="required">*</span></label>

					</td>

					<td class="left">

						<input type="text" size="3" name="UF" class="text" value="" id="UF" maxlength="2" maxsize="2" />

					</td>

				</tr>


				<tr class="trEscura">

					<td width="170px" class="right" valign="top">

						<label>Quanto tempo na doutrina ?</label>

					</td>

					<td class="left">

						<input type="text" size="40" name="QuantoTemponaDoutrina" class="text" value="" id="QuantoTemponaDoutrina" maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr>

					<td width="170px" class="right" valign="top">

						<label>Atividade Profissional que exerce:</label>

					</td>

					<td class="left">

						<input type="text" size="40" name="AtividadeProfissiona"  class="text" id="AtividadeProfissiona" value="" maxlength="100" maxsize="100" />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right" valign="top">

						<label>Escolaridade: <span class="required">*</span></label>

					</td>

					<td valign="top" class="left">

						<input type="checkbox" name="Escolaridade" class="other" id="Escolaridade_0" value="Fundamental" /> 

						<label class="left">Fundamental</label><br /> 

						<input type="checkbox" name="Escolaridade" class="other" id="Escolaridade_1" value="Secundária" /> 

						<label class="left">Secundária</label><br />

						<input type="checkbox" name="Escolaridade" class="other" id="Escolaridade_2" value="Universitária" /> 

						<label class="left">Universitária</label><br />

					</td>

				</tr>

				<tr>

					<td width="170px" class="right">

						<label>Dispõe de 5 horas por semana aprox. para o curso ? <span class="required">*</span>:</label>

					</td>

					<td class="left">

						<input type="radio" name="DispoeSemana" class="other" id="dispoeSemana_0" value="1" /> 

						<label class="left">Sim</label> <br /> 

						<input type="radio" name="DispoeSemana" class="other" id="dispoeSemana_1" value="0" /> 

						<label class="left">Não</label> <br />

					</td>

				</tr>

				<tr class="trEscura">

					<td width="170px" class="right">

						<label>Esforçar-se-á para só deixar o curso por cc de força maior ? <span class="required">*</span>:</label>

					</td>

					<td class="left">

						<input type="radio" name="ProblemaForcaMaior" class="other" id="problemaForcaMaior_0" value="1" /> 

						<label class="left">Sim</label> <br /> 

						<input type="radio" name="ProblemaForcaMaior" class="other" id="problemaForcaMaior_1" value="0" /> 

						<label class="left">Não</label> <br />

					</td>

				</tr>

				<tr>

					<td width="175px" class="right" valign="top">

						<label>Por favor, digite os caracteres ao lado: <span class="required">*</span></label>

					</td>

					<td>

						<img src="securimage/securimage_show.php?sid=<?php echo md5(uniqid(time())); ?>" id="image">&nbsp;&nbsp;

						<a href="#" onclick="document.getElementById('image').src = 'securimage/securimage_show.php?sid=' + Math.random(); return false">Carregar nova imagem</a><br /><br />

						<input type="text" id="code" name="code" size="20" />

					</td>

				</tr>

				<tr class="trEscura">

					<td align="center" colspan="2">
						

						<input type="button" class="btn" value="Inscreva-me no EAD" title="Inscreva-me no EAD" id="inscrevame" name="inscrevame" onclick="fncValidaFormulario();" />

					</td>

				</tr>

			</table>

		</form>

	</div>

</div>

<?php
	
	//Liberar o conjunto de resultados
	mysqli_free_result($resultado);

	//Fecha a conexão com o banco
	mysqli_close($conn);		

	require("includes/rodape.php");

?>