<?php

	session_start();


	require('includes/conexao.php');
	require("includes/funcoes.php");

	
	//ConfigurAçães header para forçar o download do arquivo:

	header("Content-type: application/x-msexcel; charset=iso-8859-1");


	//Este cabealho abaixo, indica que o arquivo dever ser gerado para download.

	header("Content-Disposition: attachment; filename=RelatorioDeCadastro.xls");



	//No cache, ou seja, no guarda cache, pois gerado dinamicamente

	header("Pragma: no-cache");

	header ("Cache-Control: no-cache, must-revalidate");


	$curso = (isset($_GET['curso']) ? $_GET['curso'] : ""); 

	

	//Query para retornar todos as inscritos. 

	$sql = "SELECT

				CAD.idCadastro,

				CAD.inscricao, 

				CAD.nome, 

				CAD.email,

				CUR.nomeCurso,

				CUR_CAD.idRelCursoCadastro,

				CUR_CAD.dtCadastroCurso, 

				SIT.nomeSituacao

			FROM tbl_cadastro CAD

			INNER JOIN tbl_curso_cadastro CUR_CAD ON (CAD.idCadastro = CUR_CAD.idCadastro)			

			INNER JOIN tbl_curso CUR ON (CUR.idCurso =  CUR_CAD.idCurso)

			INNER JOIN tbl_situacao_aluno SIT ON (SIT.idSituacao = CUR_CAD.idSituacao)

			WHERE (CUR.idCurso = 1)

			ORDER BY CAD.inscricao ASC;";

		
	$resultado = mysqli_query($conn, $sql);

	//-----------------------------------------------------------------



		// Criamos uma tabela HTML com o formato da planilha

		$html = '';

		$html .= "<table border='0'>";

		$html .= "	<tr style='font-size: 13px; font-family: Verdana; font-weight: bold; background-color: #E9F7E1;'>";

		$html .= "		<th align='center'>Inscrição</th>";

		$html .= "		<th align='center' width='300'>Nome</th>";

		$html .= "		<th align='center' width='140'>Data de nascimento</th>";

		$html .= "		<th align='center'>E-mail</td>";

		$html .= "		<th align='center'>Escolaridade</th>";

		$html .= "		<th align='center' width='350'>Curso</th>";

		$html .= "		<th align='center'>situação</th>";

		$html .= "		<th align='center'>Data Inscrição</th>";

		$html .= "	</tr>";



		$cont = 0;


		while($rs=mysqli_fetch_array($resultado, MYSQLI_ASSOC)){

			
			$idCad = $rs["idCadastro"];

			$inscricao = $rs["inscricao"];

			$nome = fncReplace($rs["nome"]);

			$email = fncConvTodasPalavraMinusculas($rs["email"]);

			$escolaridade = $rs["escolaridade"];

			$curso = $rs["nomeCurso"];//Nome do curso.

			$situacao = $rs["nomeSituacao"];		

			$dataInsc = formataData($rs["dtCadastroCurso"]);	


			if($cont%2 == 0){

				$cor="background-color: #EEF0F1;";

			}else{

				$cor="";

			}	


			$html .= "<tr style='font-size: 12px; font-family: Verdana; $cor'>";	

			$html .= "	<td align='center'>$inscricao</td>";

			$html .= "	<td align='left'>$nome</td>";

			$html .= "	<td align='left'>$email</td>";

			$html .= "	<td align='left'>$escolaridade</td>";

			$html .= "	<td align='left'>$curso</td>"; 

			$html .= "  <td align='left'>$situacao</td>";

			$html .= "  <td align='center'>$dataInsc</td>";

			$html .= "</tr>";	


			$cont++;

		}									

		$html .= "</table>";	


	echo $html;


	//Liberar o conjunto de resultados
	mysqli_free_result($resultado);

	//Fecha a conexão com o banco
	mysqli_close($conn);		
?>