<?php

//Anti-SQL-Inject.
function fncAntiInjection($string) {

	$string = str_ireplace(" or ", "", $string);
	$string = str_ireplace("select ", "", $string);
	$string = str_ireplace("delete ", "", $string);
	$string = str_ireplace("create ", "", $string);
	$string = str_ireplace("drop ", "", $string);
	$string = str_ireplace("update ", "", $string);
	$string = str_ireplace("drop table", "", $string);
	$string = str_ireplace("show table", "", $string);
	$string = str_ireplace("'", "", $string);
	$string = str_replace("#", "", $string);
	$string = str_replace("=", "", $string);
	$string = str_replace("--", "", $string);
	$string = str_replace("-", "", $string);
	$string = str_replace(";", "", $string);
	$string = str_replace("*", "", $string);
	$string = strip_tags($string);
	$string = addslashes($string);

	return $string;
}


//Função para remover acentos e deixar a palavra em caixa alta.
function fncReplace($string) {

	$string = str_replace("á", "a", $string);
	$string = str_replace("à", "a", $string);
	$string = str_replace("ã", "a", $string);
	$string = str_replace("â", "a", $string);
	$string = str_replace("é", "e", $string);
	$string = str_replace("ê", "e", $string);
	$string = str_replace("í", "i", $string);
	$string = str_replace("ó", "o", $string);
	$string = str_replace("ô", "o", $string);
	$string = str_replace("õ", "o", $string);
	$string = str_replace("ú", "u", $string);
	$string = str_replace("ü", "u", $string);
	$string = str_replace("ç", "c", $string);
	$string = str_replace("Á", "A", $string);
	$string = str_replace("À", "A", $string);
	$string = str_replace("Ã", "A", $string);
	$string = str_replace("Â", "A", $string);
	$string = str_replace("É", "E", $string);
	$string = str_replace("Ê", "E", $string);
	$string = str_replace("Í", "I", $string);
	$string = str_replace("Ó", "O", $string);
	$string = str_replace("Ô", "O", $string);
	$string = str_replace("Õ", "O", $string);
	$string = str_replace("Ú", "U", $string);
	$string = str_replace("Ü", "U", $string);
	$string = str_replace("Ç", "C", $string);
	$string = strtoupper($string);
	
	return $string;
}


//Função para gerar n?mero Inscrição.
function fncGeraIncricaoRand($cod) {

	//Vari?veis
	$zero = 0;

	$inicio = date("y");//Ano

	$meio = date("m");//M?s

	$cod  = $cod + 1;//N?mero incremento

	
	if(strlen($cod<1)){

		$cod = $zero.$cod;

	}

	$valorgerado = trim($inicio.$meio.$cod);

	return $valorgerado;
}


//Formatar a data para o padr?o BR dd/mm/yyyy com hora.
function formataData($data) {

	setlocale(LC_ALL, "pt_BR", "ptb");

	$data = date('d/m/Y H:i:s',strtotime($data));

	return $data;
}


//Formatar a data para o padr?o BR dd/mm/yyyy sem hora.
function formataDataSemHora($data) {

	setlocale(LC_ALL, "pt_BR", "ptb");

	$data = date('d/m/Y',strtotime($data));

	return $data;
}


//Formatar a data para o padr?o BR dd/mm/yyyy sem hora.
function formataDataCompleta() {

	setlocale(LC_ALL, "pt_BR", "ptb");

	$dia = date('d');

	$mes = date('m');

	$ano = date('Y');

	$data = $dia . $mes . $ano;

	return array ($dia, $mes ,$ano, $data);

}


//Função para converte para mai?sculas o primeiro caractere de cada palavra. 
function fncConvPrimeiraPalavraMaiuscula($string) {

	$string = mb_convert_case($string, MB_CASE_UPPER, 'iso-8859-1');

	//$string = utf8_decode(ucwords(strtolower($string)));

	return $string;

}


//Função para converte para min?sculas caractere da palavra. 
function fncConvTodasPalavraMinusculas($string) {

	$string = mb_convert_case($string, MB_CASE_LOWER, 'iso-8859-1');

	//$string = trim(strtolower($string));

	return $string;

}


//Função para enviar e-mail de confirma??o de cliente cadastro.
function fnc_email_inscricao($nome, $email, $inscricao, $numCurso) {

	//Para o envio em formato HTML

	$headers  = "MIME-Version: 1.0\r\n";

	$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";


	//Endereço do remetente

	//$headers .= "From: raphaelpereiravalle@gmail.com";

	$headers .= "From: suporte.ead@comunhaoespirita.org.br";

	//Assunto
	$assunto  = "Confirma??o de Inscrição EAD";

	//Corpo	
	$mensagem = "Sua Inscrição no curso <b>" . $numCurso . "</b>foi realizada com sucesso! A data de início das atividades está indicada no cronograma constante 
				 da página EAD da Comunhão Espírita. Pelo menos uma semana antes dessa data você receberá a confirmação de sua matrícula, o nome de seu(ua) Tutor(a), seus dados pessoais de acesso ao curso e as instruções para os trabalhos iniciais. Pedimos que faça o primeiro acesso na data indicada.<br />
				 Receba nossa saudação fraterna e votos de muita paz.<br /><br />
				 Prof. Alaciel Franklin Almeida - Coordenador do Curso.";

	@mail($email, $assunto, $mensagem, $headers);				  

}


//Função para enviar email de recupera??o de matricula.
function fnc_email_recuperar_matricula($email, $inscricao) {

	//Para o envio em formato HTML
	$headers = "MIME-Version: 1.0\r\n";

	$headers .= "Content-type: text/html; charset=iso-8859-1\r\n";


	//Endereço do remetente

	//$headers .= "From: raphaelpereiravalle@gmail.com";
	$headers .= "From: suporte.ead@comunhaoespirita.org.br";

	
	//Assunto
	$assunto = "Confirmação de Inscrição EAD";

	//Corpo

	$mensagem = "Sua Inscrição foi realizada com sucesso! Como o curso já foi iniciado, manteremos essa Inscrição para a próxima turma do curso,
				 cuja data será divulgada no site da Comunhão Espírita. Você receberá mensagem e-mail tão logo sua matrícula for realizada.
				 Receba nossa saúdação fraterna e votos de muita paz. <br /><br />
				 Prof. Alaciel Franklin Almeida - Coordenador do Curso.";

	@mail($email, $assunto, $mensagem, $headers);			  

}


//Função para c?pia o primeira parte do email antes do @.
function fncCriarUsername($string) {

	//Converte todos as letra, 

	$email = fncConvTodasPalavraMinusculas($string);

	//Refazer o _ para .

	$email = str_replace("_", ".", $email);

	//Retira a primeira parte do e-mail

	return strstr($email, '@', true);
}


//Função para c?pia o primeiro nome do usu?rio
function fncCopiarPrimeiraNome($nome) {

	$nome = fncConvPrimeiraPalavraMaiuscula($nome);

	//Retira a primeira parte do e-mail

	return mb_strstr($nome, ' ', true);
}


//Função para c?pia o primeiro nome do usu?rio
function fncCopiarSobreNome($nome) {

	$nome = fncConvPrimeiraPalavraMaiuscula($nome);

	//Retira a primeira parte do e-mail

	return mb_strstr($nome, ' ', false);
}

function fncTelefone($string) {
	
	$string = str_replace("-", "", $string);
	$string = str_replace(".", "", $string);
	$string = str_replace("/", "", $string);
	$string = str_replace("(", "", $string);
	$string = str_replace(")", "", $string);
	$string = str_replace(" ", "", $string);
	$string = str_replace("+", "", $string);
	
	return $string;
}

?>