/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

 Função: fncValidaMail

 Parâmetros: string

 Descrição: Função para validar e-mails

 Retorna: true ou false

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/


function fncValidaMail(mail) {

	var er = new RegExp(/^[A-Za-z0-9_\-\.]+@[A-Za-z0-9_\-\.]{2,}\.[A-Za-z0-9]{2,}(\.[A-Za-z0-9])?/);

	if (typeof (mail) == "string") {

		if (er.test(mail)) { return true; }

	} else if (typeof (mail) == "object") {

		if (er.test(mail.value)) { return true; }

	} else {
		return false;
	}
}



/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

 Função: fncValidaNomeCompleto

 Parâmetros: string

 Descrição: Função para validar o nome completo do usuário.

 Retorna: true ou false

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function fncValidaNomeCompleto(nome) {

	var separado = nome.split(" ");

	var totalSeparador = separado.length;

	if (totalSeparador <= 1) {

		return false;

	} else {

		return true;

	}
}

/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

 Função: fncValidaLoginFrmInscrisaoExistente

 Parâmetros: idFormulario, nome code.

 Descrição: Função para validar tela de inscrição já existente.

 Retorna: 

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncValidaLoginFrmInscrisaoExistente() {

	var objFormulario = document.getElementById("frmLoginInscricaoExistente");

	var nome = document.getElementById("Nome").value;
	var email = document.getElementById("Email").value;
	var code = document.getElementById("code").value;

	var msg = "";

	//Nome
	if (email == "") {

		if (nome == "") {

			msg = msg + "\n- E necessario informar a inscricao!";

			document.getElementById("Nome").focus();

		}

	}

	//E-mail
	if (nome == "") {

		if (!email) {

			msg = msg + "\n- E necessario informar o e-mail!";

			document.getElementById("Email").focus();

		} else if (!fncValidaMail(email)) {

			msg = msg + "\n- E-mail invalido!";
		}
	}

	//Imagem de segurança
	if (code == "") {

		msg = msg + "\n- É necessário digitar os caractes da imagem de segurança!";

		document.getElementById("code").focus();

	}


	if (msg) {

		msg = "Campo(s) vazio(s):\n" + msg;

		alert(msg);

	} else {

		objFormulario.action = "acoes/confirmar_inscricao.php?tipo=E";//Redireciona para a página de confirma inscricao

		objFormulario.submit();

	}
}



/*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

 Função: fncValidaFormulario

 Parâmetros: Dados do formulario

 Descrição: Função para validar formulario de cadastro do cliente

 Retorna: Tipo E - edição e id do cadastro do aluno.



----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/

function fncValidaFormulario() {

	var objFormulario = document.getElementById("frmNovaInscricao");

	var curso = document.getElementsByName("Curso");

	var nome = document.getElementById("Nome").value;

	var email = document.getElementById("Email").value;

	var confirmarEmail = document.getElementById("ConfirmarEmail").value;

	var nacionalidade = document.getElementsByName("Nacionalidade");

	var telResidencial = document.getElementById("TelResidencial").value;
	//console.log("telResidencial" + telResidencial);
	//console.log("telResidencial" + telResidencial.replace(/\D/g, ""));
	//console.log("telResidencial" + telResidencial.replace('(', '').replace(')', '').replace('-', ' '));


	var telCelular = document.getElementById("TelCelular").value;
	//console.log("telCelular" + telCelular);
	var pais = document.getElementById("Pais").value;

	var endereco = document.getElementById("Endereco").value;

	var bairro = document.getElementById("Bairro").value;

	var cidade = document.getElementById("Cidade").value;

	var uf = document.getElementById("UF").value;

	var cep = document.getElementById("cep").value;

	var escolaridade = objFormulario.Escolaridade;

	var dispoe5Semana = document.getElementsByName("DispoeSemana");

	var code = document.getElementById("code").value;

	var okCurso = false;

	var okEsc = false;

	var okEx = false;

	var okDispoe = false

	var okNacionalidade = false;

	var msg = "";



	//Curso

	for (i = 0; i < curso.length; i++) {

		if (curso[i].checked) {

			okCurso = true;

		}

	}


	if (!okCurso) {
		msg = msg + "\n - Curso!";
	}

	//Nome
	if (nome == "") {

		msg = msg + "\n - Nome completo!";

		document.getElementById("Nome").focus();

	} else if (!fncValidaNomeCompleto(nome)) {

		msg = msg + "\n - Digite o nome completo!";

	}

	//E-mail
	if (!email) {

		msg = msg + "\n - E-mail!";

		document.getElementById("Email").focus();

	} else if (!fncValidaMail(email)) {

		msg = msg + "\n - E-mail invalido!";

	}

	//Confrimar E-mail
	if (!confirmarEmail) {

		msg = msg + "\n - E-mail de confirmacao!";

		document.getElementById("ConfirmarEmail").focus();

	} else if (!fncValidaMail(confirmarEmail)) {

		msg = msg + "\n - E-mail de confirmacao invalido!";

	}

	//Verifica os e-mails digitados
	if (email != confirmarEmail) {

		msg = msg + "\n - E-mail e a confirmacao do e-mail sao semelhantes!";

	}

	//Nacionalidade 
	for (i = 0; i < nacionalidade.length; i++) {

		if (nacionalidade[i].checked) {

			okNacionalidade = true;

		}

	}

	if (!okNacionalidade) {
		msg = msg + "\n - Nacionalidade!";
	}

	//Telefone residencial
	if (telResidencial == "") {
		msg = msg + "\n - Telefone residencial!";
		document.getElementById("TelResidencial").focus();
	}

	//Telefone celular
	if (telCelular == "") {

		msg = msg + "\n - Telefone celular!";

		document.getElementById("TelCelular").focus();

	}

	//País
	if (pais == "") {

		msg = msg + "\n - Pais!";

		document.getElementById("Pais").focus();
	}

	//Endereço
	if (endereco == "") {

		msg = msg + "\n - Endereco!";

		document.getElementById("Endereco").focus();

	}

	//Bairro
	if (bairro == "") {

		msg = msg + "\n - Bairro!";

		document.getElementById("Bairro").focus();
	}

	//Cidade
	if (cidade == "") {

		msg = msg + "\n - Cidade!";

		document.getElementById("Cidade").focus();

	}



	//UF

	if (uf == "") {

		msg = msg + "\n - UF!";

		document.getElementById("UF").focus();

	}



	//CEP

	if (cep == "") {

		msg = msg + "\n - CEP!";

		document.getElementById("cep").focus();

	}



	//Escolaridade

	for (i = 0; i < escolaridade.length; i++) {

		if (escolaridade[i].checked) {

			okEsc = true;

		}

	}


	if (!okEsc) {

		msg = msg + "\n - Escolaridade!";
	}


	//Dispõe de 5 horas por semana 
	for (i = 0; i < dispoe5Semana.length; i++) {

		if (dispoe5Semana[i].checked) {

			okDispoe = true;

		}
	}


	//form = document.forms[0];

	//Dispõe

	//False não esta marcado

	if ((objFormulario.dispoeSemana_0.checked == false) && (objFormulario.dispoeSemana_1.checked == false)) {

		msg = msg + "\n - Compromisso de dedicar pelo menos 5 horas ao curso!";

	}//else if (objFormulario.dispoeSemana_1.checked != false){//Caso seje não o usuário receberar um mensagem de alerta e será redirecionado.

	//	if(objFormulario.dispoeSemana_1.value == 0)

	//	{		

	//		fncNaoDispoetempo();

	//		return false; 

	//	}			

	//}



	//

	if ((objFormulario.problemaForcaMaior_0.checked == false) && (objFormulario.problemaForcaMaior_1.checked == false)) {

		msg = msg + "\n - Compromisso para so deixar o curso em caso de forca maior";

	}//else if (objFormulario.problemaForcaMaior_1.checked != false){//Caso seje não o usuário receberar um mensagem de alerta e será redirecionado.

	//if(objFormulario.problemaForcaMaior_1.value == 0)

	//{		

	//	fncProblemaDeForcaMaior();

	//	return false; 

	//}

	//}

	//Imagem de segurança
	if (code == "") {
		msg = msg + "\n - Caracteres da imagem de seguranca!";
		document.getElementById("code").focus();
	}


	if (msg) {
		msg = "E necessario informar:" + msg;
		alert(msg);
	} else {
		objFormulario.action = "acoes/confirmar_inscricao.php?tipo=N";
		objFormulario.submit();
	}
}



//Habilitar o campo de Identificacao

function fncHabilita(valor, conteudo, status) {

	//Limpa o style.
	document.getElementById("campoIdentificador").style.display = '';

	//Verificar o tipo de Identificacao 1 ou 2.
	if (valor == 1) {
		document.getElementById('campoIdentificador').innerHTML = "<td width='170px' class='right'><label>Inclua seu CPF: <span class='required'>*</span></label></td><td class='left'><input type='text' size='60' name='Identificacao' id='Identificacao' class='text' maxlength='20' maxsize='20' " + status + " /></td>";
	} else {
		document.getElementById('campoIdentificador').innerHTML = "<td width='170px' class='right'><label>Inclua o número de sua identidade: <span class='required'>*</span></label></td><td class='left'><input type='text' size='60' name='Identificacao' id='Identificacao' class='text'  maxlength='20' maxsize='20' " + status + " /></td>";
	}
}



//Habilitar o campo de Identificacao no modo de edição.

function fncHabilitaEditar(valor, conteudo, status) {

	//Verificar o tipo de Identificacao 1 ou 2

	if (valor == 1) {

		document.getElementById('campoIdentificador').innerHTML = "<td width='170px' class='right'><label>Inclua seu CPF: <span class='required'>*</span></label></td><td class='left'><input type='text' size='60' name='Identificacao' id='Identificacao' class='text' value = '" + conteudo + "' maxlength='20' maxsize='20' " + status + " /></td>";

	} else {

		document.getElementById('campoIdentificador').innerHTML = "<td width='170px' class='right'><label>Inclua o número de sua identidade: <span class='required'>*</span></label></td><td class='left'><input type='text' size='60' name='Identificacao' id='Identificacao' class='text' value = '" + conteudo + "' maxlength='20' maxsize='20' " + status + " /></td>";

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncValidaFormularioExistente
	
 Parâmetros: 
	
 Descrição:  
	
 Retorna:  
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncValidaFormularioExistente() {

	var objFormulario = document.getElementById("frmInscricaoExistente");

	var idCur = 0;

	var curso = document.getElementsByName("Curso");

	var idCad = document.getElementById("idCadastro").value;

	var nome = document.getElementById("Nome").value;

	var email = document.getElementById("Email").value;

	var telResidencial = document.getElementById("TelResidencial").value;

	var telCelular = document.getElementById("TelCelular").value;

	var confirmarEmail = document.getElementById("ConfirmarEmail").value;

	var nacionalidade = document.getElementsByName("Nacionalidade");

	var identificacao = document.getElementsByName("Identificacao");

	var pais = document.getElementById("Pais").value;

	var endereco = document.getElementById("Endereco").value;

	var bairro = document.getElementById("Bairro").value;

	var cidade = document.getElementById("Cidade").value;

	var uf = document.getElementById("UF").value;

	var cep = document.getElementById("cep").value;

	var escolaridade = document.forms[0].Escolaridade;

	var code = document.getElementById("code").value;

	var okCurso = false;

	var okEsc = false;

	var okEx = false;

	var msg = "";



	//Curso

	for (i = 0; i < curso.length; i++) {

		if (curso[i].checked) {

			okCurso = true;

			idCur = curso[i].value;

		}

	}



	if (!okCurso) {

		msg = msg + "\n- Curso!";

	}



	//Nome

	if (nome == "") {

		msg = msg + "\n- Nome!";

		document.getElementById("Nome").focus();

	} else if (!fncValidaNomeCompleto(nome)) {

		msg = msg + "\n - Digite o nome completo!";

	}



	//E-mail

	if (!email) {

		msg = msg + "\n- E-mail!";

		document.getElementById("Email").focus();

	} else if (!fncValidaMail(email)) {

		msg = msg + "\n- E-mail invalido!";

	}



	//Confrimar E-mail

	if (!confirmarEmail) {

		msg = msg + "\n- E-mail de confirmação!";

		document.getElementById("ConfirmarEmail").focus();

	} else if (!fncValidaMail(confirmarEmail)) {

		msg = msg + "\n- E-mail de confirmação invalido!";

	}



	//Verifica os e-mails digitados

	if (email != confirmarEmail) {

		msg = msg + "\n- E-mail e a confirmação do e-mail são semelhantes!";

	}



	//Telefone residencial

	if (telResidencial == "") {

		msg = msg + "\n- Telefone residencial!";

		document.getElementById("TelResidencial").focus();

	}



	//Telefone celular

	if (telCelular == "") {

		msg = msg + "\n - Telefone celular!";

		document.getElementById("TelCelular").focus();

	}



	//Nacionalidade 

	for (i = 0; i < nacionalidade.length; i++) {

		if (nacionalidade[i].checked) {

			okNacionalidade = true;

		}

	}



	if (!okNacionalidade) {

		msg = msg + "\n- Nacionalidade!";

	}



	//País

	if (pais == "") {

		msg = msg + "\n- País!";

		document.getElementById("Pais").focus();

	}



	//Endereço

	if (endereco == "") {

		msg = msg + "\n- Endereço!";

		document.getElementById("Endereco").focus();

	}



	//Cidade

	if (cidade == "") {

		msg = msg + "\n- Cidade!";

		document.getElementById("Cidade").focus();

	}



	//Bairro

	if (bairro == "") {

		msg = msg + "\n- Bairro!";

		document.getElementById("Bairro").focus();

	}



	//UF

	if (uf == "") {

		msg = msg + "\n- UF!";

		document.getElementById("UF").focus();

	}



	//CEP

	if (cep == "") {

		msg = msg + "\n- CEP!"

		document.getElementById("cep").focus();

	}



	//Escolaridade

	for (i = 0; i < escolaridade.length; i++) {

		if (escolaridade[i].checked) {

			okEsc = true;

		}

	}



	if (!okEsc) {

		msg = msg + "\n- Escolaridade!";

	}



	form = document.forms[0];



	//Dispõe

	if ((form.dispoeSemana_0.checked == false) && (form.dispoeSemana_1.checked == false)) {

		msg = msg + "\n- Compromisso de dedicar pelo menos 5 horas ao curso";

	}



	//

	if ((form.problemaForcaMaior_0.checked == false) && (form.problemaForcaMaior_1.checked == false)) {

		msg = msg + "\n- Compromisso para só deixar o curso em caso de força maior";

	}



	//Imagem de segurança

	if (code == "") {

		msg = msg + "\n- Caractes da imagem de segurança!";

		document.getElementById("code").focus();

	}



	if (msg) {

		msg = "E necessario informar:" + msg;

		alert(msg);

	} else {

		objFormulario.action = "acoes/atualizar_inscricao.php?tipo=E&idCad=" + idCad + "&idCur=" + idCur;

		objFormulario.submit();

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncValidaFormularioDetalhar
	
 Parâmetros: 
	
 Descrição: Validar formulário para subimit do mesmo. 
	
 Retorna:  
	
	
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/


function fncValidaFormularioDetalhar() {

	var objFormulario = document.getElementById("frmInscricaoDetalha");

	var idCad = document.getElementById("idCadastro").value;

	var okEx = false;

	var msg = "";


	if (!msg) {

		objFormulario.action = "acoes/confirmar_inscricao_detalhas.php?tipo=E&idCad=" + idCad;

		objFormulario.submit();

	}

}


/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncNaoDispoetempo
	
 Parâmetros: 
	
 Descrição: Função para alertar o usuário sobre a disposição do tempo para o curso. Caso seje não o usuário receberar um mensagem de alerta e será redirecionado.	 	
	
 Retorna:  
	
	
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncNaoDispoetempo(cod) {

	if (cod == 0) {

		alert("Como explicado nas informações apresentadas neste site, você precisará dedicar, aproximadamente 5 horas por semana para o curso. Favor confirmar essa disponibilidade de tempo para que possamos aceitar sua inscrição.");

		document.getElementById("btnEnviar").disabled = true;

		document.getElementById("btnEnviar").className = 'btnDisabled';

	} else {

		document.getElementById("btnEnviar").disabled = false;

		document.getElementById("btnEnviar").className = 'btn';

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncProblemaDeForcaMaior
	
 Parâmetros: 
	
 Descrição: Função para alertar o usuário sobre o compremetimento do para o curso. 	
	
 Retorna:  
	
	
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncProblemaDeForcaMaior(cod) {

	if (cod == 0) {

		alert("Como explicado nas informações apresentadas neste site, as vagas para este curso são limitadas. Ao responder “SIM” a esta pergunta, você estará assumindo compromisso de se esforçar para aproveitar a vaga que lhe for concedida e permanecer no curso até o final, a não ser em caso de força maior.");

		document.getElementById("btnEnviar").disabled = true;

		document.getElementById("btnEnviar").className = 'btnDisabled';

	} else {

		document.getElementById("btnEnviar").disabled = false;

		document.getElementById("btnEnviar").className = 'btn';

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncFormatCampos
	
 Parâmetros: 
	
 Descrição: Formata um campo do formulário de acordo com a máscara informada...
	
 Retorna:  
	
	
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



/* 
	
* Parâmetros: - objForm (o Objeto Form)
	
* - strField (string contendo o nome do textbox) - sMask (mascara que define o * formato que o dado será apresentado, * usando o algarismo "9" para  definir números e o símbolo "!" para  qualquer caracter...  - evtKeyPress (evento) Uso.......: <input type="textbox"  name="xxx".... onkeypress="return txtBoxFormat(document.rcfDownload, 'str_cep', '99999-999', event);">
	
* Observação: As máscaras podem ser representadas como os exemplos abaixo:
	
* CEP -> 99.999-999
	
* CPF -> 999.999.999-99
	
* CNPJ -> 99.999.999/9999-99
	
* Data -> 99/99/9999
	
* Tel Resid -> (99) 999-9999
	
* Tel Cel -> (99) 9999-9999
	
* Processo -> 99.999999999/999-99
	
* C/C -> 999999-!
	
* E por aí vai...
	
*/


function fncFormatCampos(strField, sMask, evtKeyPress) {

	var i, nCount, sValue, fldLen, mskLen, bolMask, sCod, nTecla;

	if (window.event) { //Internet Explorer

		nTecla = evtKeyPress.keyCode;

	} else if (evtKeyPress.which) { //Firefox

		nTecla = evtKeyPress.which;

	}

	//se for backspace não faz nada
	if (nTecla != 8) {

		sValue = document.getElementById(strField).value;
		console.log(sValue);
		// Limpa todos os caracteres de formatação que
		// já estiverem no campo.

		sValue = sValue.toString().replace("-", "");
		sValue = sValue.toString().replace(".", "");
		sValue = sValue.toString().replace("/", "");
		sValue = sValue.toString().replace("(", "");
		sValue = sValue.toString().replace(")", "");
		sValue = sValue.toString().replace(" ", "");
		sValue = sValue.toString().replace("+", "");
		fldLen = sValue.length;

		mskLen = sMask.length;

		i = 0;

		nCount = 0;

		sCod = "";

		mskLen = fldLen;

		while (i <= mskLen) {

			bolMask = ((sMask.charAt(i) == "-") || (sMask.charAt(i) == ".") || (sMask.charAt(i) == "/"))

			bolMask = bolMask || ((sMask.charAt(i) == "(") || (sMask.charAt(i) == ")") || (sMask.charAt(i) == " "))

			if (bolMask) {
				sCod += sMask.charAt(i);
				mskLen++;
			} else {
				sCod += sValue.charAt(nCount);
				nCount++;
			}

			i++;
		}

		document.getElementById(strField).value = sCod;

		if (nTecla != 8) { // backspace

			if (sMask.charAt(i - 1) == "9") { // apenas números...
				return ((nTecla > 47) && (nTecla < 58)); // números de 0 a 9
			} else {
				return true;// qualquer caracter...
			}

		} else {
			return true;
		}

	}//fim do if que verifica se é backspace
}


/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncBloqueiCopiaCola
	
 Parâmetros: tecla 17 e 118
	
 Descrição:  
	
 Retorna:  
	
	
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncBloqueiCopiaCola(event) {

	var ctrl = typeof event.modifiers == 'undefined' ? event.ctrlKey : event.modifiers & event.CONTROL_MASK;

	var v = typeof event.which == 'undefined' ? event.keyCode == 86 : event.which == 86;


	// If the control and 'V' keys are pressed at the same time

	if (ctrl && v) {
		document.forms['frmNovaInscricao'].elements['ConfirmarEmail'].value = '';
		return false;
	}

	return true;
}


function fncOrdena() {

	var objFormulario = document.getElementById("frm_listegem");

	var ordena = document.getElementById("ordena").value;

	objFormulario.submit();

}


function fncLimiteDeRegistros() {

	var objFormulario = document.getElementById("frm_listegem");

	var numeroDeRegistros = document.getElementById("numeroDeRegistros").value;

	objFormulario.submit();

}


function isNumeric(str) {

	var er = /^[0-9]+$/;

	return (er.test(str));

}


function fncPesquisa() {

	var objFormulario = document.getElementById("frm_pesquisa");

	var nome = document.getElementById("txtPesquisar").value;
	//console.log("txtPesquisar " + nome);
	var chk = document.getElementsByName("TipoPesquisa");

	var okChk = false;


	for (i = 0; i < chk.length; i++) {

		if (chk[i].checked) {
			okChk = true;
		}
		//console.log("TipoPesquisa " + chk[i].checked);
	}

	if (okChk == true) {

		var valor = isNumeric(nome);
		//console.log("valor " + valor);
		var n1;

		var n2;

		var tpPeq;


		if (valor) {

			n2 = nome;

			tpPeq = 1;

		} else {

			n1 = nome.split(" - ");

			n2 = n1[0].trim();

			tpPeq = 2;

		}

		if (nome != "Não existe o registro pesquisado!") {

			objFormulario.action = "frm_inscricao_detalhas.php?str=" + n2 + "&acao=e&tpPeq=" + tpPeq;

			objFormulario.submit();

		} else {

			objFormulario.action = "frm_pesquisar.php?r=3";

			objFormulario.submit();

		}

	} else {

		alert("Campo vazio:\nSelecione o campo de opção de pesquisa!");

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncLogin
	
 Parâmetros: login e senha
	
 Descrição: Verificar se o login e senha estão corretos
	
 Retorna:  
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncLogin() {

	var objFormulario = document.getElementById("frm_login");

	var login = document.getElementById("login").value;

	var senha = document.getElementById("senha").value;

	var msg = "";



	if (login == "") {

		msg = " -Login\n"

		document.getElementById("login").focus();

	}



	if (senha == "") {

		msg = msg + " -Senha\n"

		document.getElementById("senha").focus();

	}



	if (msg != "") {

		msg = "É preciso preenche os campo(s):\n\n" + msg;

		alert(msg);

	} else {

		objFormulario.submit();

	}

}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncNovaInscricao
	
 Parâmetros: Sem 
	
 Descrição: Redirecionar para a página de nova inscrição
	
 Retorna:  
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncNovaInscricao() {

	var objFormulario = document.getElementById("frm_ead");

	objFormulario.action = "frm_nova_inscricao.php";

	objFormulario.submit();

}



//$(document).ready(function(){

//	$("#btnNovaInscricao").click(function {

//		$("#frm_ead").attr("action","frm_nova_inscricao.php");

//	})

//})



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncJaSoInscrido
	
 Parâmetros: tipo E - edição 
	
 Descrição: Redirecionar para a página de já inscrição o usuário poderá novamente efetuar uma inscrição ou não, haverá uma validação antes.
	
 Retorna:  
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/


function fncJaSoInscrido() {

	var objFormulario = document.getElementById("frm_ead");

	objFormulario.action = "frm_inscricao_existente.php?tipo=E";

	objFormulario.submit();

	//document.forms["frm_ead"].action = "frm_inscricao_existente.php?tipo=E";

	//document.forms["frm_ead"].submit();

}


function fncValidarFormCurso() {

	var objFormulario = document.getElementById("frmCurso");

	var nomeCurso = document.getElementById("NomeCurso").value;

	var descricaoCurso = document.getElementById("Descricao").value;

	var okCurso = false;

	var msg = "";



	if (nomeCurso == "") {

		msg = msg + "\n-Preencha o campo de nome!";

		document.getElementById("NomeCurso").focus();

	}



	if (descricaoCurso == "") {

		msg = msg + "\n-Preencha o campo de descrição!";

		document.getElementById("Descricao").focus();

	}



	if (msg) {

		msg = "Campo(s) vazio(s):\n" + msg;

		alert(msg);

	} else {

		objFormulario.action = "acoes/confirmar_curso.php";
		objFormulario.submit();

	}

}

//
function fncSituacao(valorCombo, idCurso, idCadastro) {

	var objFormulario = document.getElementById("frmInscricaoDetalha");

	//A variável valorCombo o valor randCod do php, depois ele é concatenada com a strig situacao para gerar o mesmo id do select, dessa forma é possivel reculperar o valor real. 

	var combo = "situacao" + valorCombo;

	var idComb = document.getElementById(combo).value;

	var idRel = idCurso;

	var idCad = idCadastro;



	objFormulario.action = "acoes/confirmar_inscricao_detalhas.php?tipo=U&idComb=" + idComb + "&idCurso=" + idCurso + "&idCad=" + idCad;

	objFormulario.submit();

}



function fncRelCursoCadastro(idCurso, idCadastro) {

	var objFormulario = document.getElementById("frmInscricaoDetalha");

	var idCur = idCurso;
	var idCad = idCadastro;

	var conctenaIdRelCursoCadastro = document.getElementById("relCursoCadastro" + idCur).value;

	objFormulario.action = "acoes/confirmar_inscricao_detalhas.php?tipo=UE&idCurso=" + idCur + "&idCad=" + idCad + "&conctenaIdRelCursoCadastro=" + conctenaIdRelCursoCadastro;

	objFormulario.submit();
}



/*--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
 Função: fncDeletarAluno
	
 Parâmetros: id do aluno e tipo de ação
	
 Descrição: Redirecionar para a página que executar a deleção
	
 Retorna:  
	
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/



function fncDeletarAluno(idCadastro) {

	var status = confirm("Deseja deletar o aluno?");

	if (status) {

		var objFormulario = document.getElementById("frm_listegem");

		objFormulario.action = "acoes/deletar_aluno.php?id=" + idCadastro + "&acao=d";

		objFormulario.submit();

	}
}



// /*----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

// ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------*/


//Função para gerar relatório de matriculas.
function getRelatorioMatriculas() {
	$.ajax({
		type: 'POST',
		async: false,
		cache: false,
		dataType: 'html',
		beforeSend: function () {
			loader();
		},
		success: function () {
			window.location = 'frm_relatorio_para_matricula.php';
		},
		complete: function () {
			$("#loading").remove();
		},
		error: function (e) {
			console.log(e);
		}
	});
}

//Carregar página cadastrar usuários
function getRelatorioGeral() {
	$.ajax({
		type: 'POST',
		async: false,
		cache: false,
		dataType: 'html',
		beforeSend: function () {
			loader();
		},
		success: function () {
			window.location = 'frm_relatorio_geral.php';
		},
		complete: function () {
			$("#loading").remove();
		},
		error: function (e) {
			console.log(e);
		}
	});
}

//Carregar página cadastrar usuários
function getRelatorioQuantitativo() {
	$.ajax({
		type: 'POST',
		async: false,
		cache: false,
		//dataType: 'html',
		beforeSend: function () {
			loader();
		},
		success: function () {
			window.location = 'frm_relatorio_quantitativo.php';
		},
		complete: function () {
			$("#loading").remove();
		},
		error: function (e) {
			console.log(e);
		}
	});
}

function loader() {

	var html = "<img src='images/ajax_loader.gif' />";

	return $('#loading').append(html);
}

function buscarCep(input) {

	var input = document.getElementById('cep').value
	var cep = input.replace(/\D/g, '');

	if (cep != "") {
		fetch(`https://viacep.com.br/ws/${cep}/json/`)
			.then(response => response.json())
			.then(data => {
				if (data.erro) {
					alert('CEP não encontrado.');
					return;
				}
				document.getElementById('cep').value = data.cep;
				document.getElementById('Bairro').value = data.bairro;
				document.getElementById('Complemento').value = data.complemento;
				document.getElementById('Cidade').value = data.localidade;
				document.getElementById('Endereco').value = data.logradouro;
				document.getElementById('UF').value = data.uf;
			})
			.catch(error => {
				alert('Erro ao buscar o CEP.');
				console.error('Erro:', error);
			});
	} else {
		alert('CEP invalido! Consulta novamente.');
		console.log(erro);
	}
}


